require(nnet)
require(openxlsx)
ml<-read.xlsx("haplo_train.xlsx", sheet=1,na.strings=c("NN", ""))
ml$Population=as.factor(ml$Population)
ml$Population2<-relevel(ml$Population,ref="POPA")  #POPA is the reference population
test<-multinom(Population2 ~ Locus01+Locus02+Locus03+Locus04+Locus05+Locus06+Locus07+Locus08+Locus09+Locus10+MH1+MH2+MH3,data=ml,maxit=1000,MaxNWts=5000)
pp<-fitted(test)
predictions<-predict(test)  #predicted populations (not every individual should have one)
ml$Population #real populations


#for single predictions
myprofile2classify<-data.frame(Locus01="GG",Locus02="AG",Locus03="CC",Locus04="AA",Locus05="AA",Locus06="CC",Locus07="GG",Locus08="CC",Locus09="CG",Locus10="GG",MH1="AGGCC/GGGCC",MH2="AG/AG",MH3="ACC/TTT")
predict(test,type="probs",na.action="na.exclude",newdata=myprofile2classify)  #likelihoods for each population
predict(test,na.action="na.exclude",newdata=myprofile2classify)  #predicted population

# for multiple predictions
myprofiles<-read.xlsx("haplo_test.xlsx", sheet=1,na.strings=c("NN", ""))
predict(test,type="probs",na.action="na.exclude",newdata=myprofiles)  #likelihoods for each population
predict(test,na.action="na.exclude",newdata=myprofiles)  #predicted populations
myprofiles$Population  #real populations
predict(test,na.action="na.exclude",newdata=myprofiles) == myprofiles$Population  #compare predictions and real populations
